/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.event.common.ExplosionEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_8567;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.gadgets.entity.EFLNExplosion;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class Exploder {
    public final double r;
    private final double rr;
    public final int dist;
    private final double explosionStrength;
    private final int blocksPerIteration;
    public final int x;
    public final int y;
    public final int z;
    public final class_1937 world;
    private final class_1297 exploder;
    private final EFLNExplosion explosion;
    private int currentRadius;
    private int curX;
    private int curY;
    private int curZ;
    private final List<class_1799> droppedItems;
    private static final List<Exploder> CACHED_EXPLOSIONS = new ArrayList<Exploder>();

    public Exploder(class_1937 world, EFLNExplosion explosion, class_1297 exploder, class_2338 location, double r, double explosionStrength, int blocksPerIteration) {
        this.r = r;
        this.world = world;
        this.explosion = explosion;
        this.exploder = exploder;
        this.rr = r * r;
        this.dist = (int)r + 1;
        this.explosionStrength = explosionStrength;
        this.blocksPerIteration = blocksPerIteration;
        this.currentRadius = 0;
        this.x = location.method_10263();
        this.y = location.method_10264();
        this.z = location.method_10260();
        this.curX = 0;
        this.curY = 0;
        this.curZ = 0;
        this.droppedItems = Lists.newArrayList();
    }

    public static void startExplosion(class_1937 world, EFLNExplosion explosion, class_1297 entity, class_2338 location, double r, double explosionStrength) {
        Exploder exploder = new Exploder(world, explosion, entity, location, r, explosionStrength, Math.max(50, (int)(r * r * r / 10.0)));
        exploder.handleEntities();
        world.method_8396(null, location, class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f);
        CACHED_EXPLOSIONS.add(exploder);
    }

    private void handleEntities() {
        Predicate<class_1297> predicate = entity -> entity != null && !entity.method_5659() && class_1301.field_6155.test(entity) && class_1301.field_6154.test(entity) && entity.method_19538().method_1028((double)this.x, (double)this.y, (double)this.z) <= this.r * this.r;
        List list = this.world.method_8333(this.exploder, new class_238((double)this.x - this.r - 1.0, (double)this.y - this.r - 1.0, (double)this.z - this.r - 1.0, (double)this.x + this.r + 1.0, (double)this.y + this.r + 1.0, (double)this.z + this.r + 1.0), predicate);
        ((ExplosionEvents.Detonate)ExplosionEvents.DETONATE.invoker()).onDetonate(this.world, (class_1927)this.explosion, list, this.r * 2.0);
        for (class_1297 entity2 : list) {
            class_243 dir = entity2.method_19538().method_1020(this.exploder.method_19538().method_1031(0.0, -this.r / 2.0, 0.0));
            double str = (this.r - dir.method_1033()) / this.r;
            str = Math.max(0.3, str);
            dir = dir.method_1029();
            dir = dir.method_1021(this.explosionStrength * str * 0.3);
            entity2.method_5762(dir.field_1352, dir.field_1351 + 0.5, dir.field_1350);
            entity2.method_5643(entity2.method_48923().method_48807((class_1927)this.explosion), (float)(str * this.explosionStrength));
            if (!(entity2 instanceof class_3222)) continue;
            TinkerNetwork.getInstance().sendTo(new EntityMovementChangePacket(entity2), (class_3222)entity2);
        }
    }

    public void onTick(class_3218 world) {
        if (world == this.world && !this.iteration()) {
            this.finish();
        }
    }

    private void finish() {
        int d = (int)this.r / 2;
        class_2338 pos = new class_2338(this.x - d, this.y - d, this.z - d);
        Random random = new Random();
        ArrayList aggregatedDrops = Lists.newArrayList();
        for (class_1799 drop : this.droppedItems) {
            boolean notInList = true;
            for (class_1799 stack : aggregatedDrops) {
                if (!class_1799.method_31577((class_1799)drop, (class_1799)stack)) continue;
                stack.method_7933(drop.method_7947());
                notInList = false;
                break;
            }
            if (!notInList) continue;
            aggregatedDrops.add(drop);
        }
        for (class_1799 drop : aggregatedDrops) {
            class_1799 dropItemstack;
            int stacksize = drop.method_7947();
            do {
                class_2338 spawnPos = pos.method_10069(random.nextInt((int)this.r), random.nextInt((int)this.r), random.nextInt((int)this.r));
                dropItemstack = drop.method_7972();
                dropItemstack.method_7939(Math.min(stacksize, 64));
                class_2248.method_9577((class_1937)this.world, (class_2338)spawnPos, (class_1799)dropItemstack);
            } while ((stacksize -= dropItemstack.method_7947()) > 0);
        }
    }

    private boolean iteration() {
        int count = 0;
        this.explosion.method_8352();
        while (count < this.blocksPerIteration && this.currentRadius < (int)this.r + 1) {
            double d = this.curX * this.curX + this.curY * this.curY + this.curZ * this.curZ;
            if (d <= this.rr) {
                class_2338 blockpos = new class_2338(this.x + this.curX, this.y + this.curY, this.z + this.curZ);
                class_2680 blockState = this.world.method_8320(blockpos);
                class_3610 ifluidstate = this.world.method_8316(blockpos);
                if (!blockState.method_26215() || !ifluidstate.method_15769()) {
                    double f = this.explosionStrength * (1.0 - d / this.rr);
                    float f2 = Math.max(blockState.method_26204().method_9520(), ifluidstate.method_15760());
                    if (this.exploder != null) {
                        f2 = this.exploder.method_5774((class_1927)this.explosion, (class_1922)this.world, blockpos, blockState, ifluidstate, f2);
                    }
                    if ((f -= (double)((f2 + 0.3f) * 0.3f)) > 0.0 && (this.exploder == null || this.exploder.method_5853((class_1927)this.explosion, (class_1922)this.world, blockpos, blockState, (float)f))) {
                        ++count;
                        this.explosion.addAffectedBlock(blockpos);
                    }
                }
            }
            this.step();
        }
        ((ExplosionEvents.Detonate)ExplosionEvents.DETONATE.invoker()).onDetonate(this.world, (class_1927)this.explosion, Collections.emptyList(), this.r * 2.0);
        this.explosion.method_8346().forEach(this::explodeBlock);
        return count == this.blocksPerIteration;
    }

    private void step() {
        if (++this.curX > this.currentRadius) {
            this.curX = -this.currentRadius;
            if (++this.curZ > this.currentRadius) {
                this.curZ = -this.currentRadius;
                if (--this.curY < -this.currentRadius) {
                    ++this.currentRadius;
                    this.curX = this.curZ = -this.currentRadius;
                    this.curY = this.currentRadius;
                }
            }
        }
        if (this.curY != -this.currentRadius && this.curY != this.currentRadius && this.curZ != -this.currentRadius && this.curZ != this.currentRadius && this.curX > -this.currentRadius) {
            this.curX = this.currentRadius;
        }
    }

    private void explodeBlock(class_2338 blockpos) {
        class_2680 blockstate = this.world.method_8320(blockpos);
        if (!this.world.field_9236 && blockstate.method_26204().method_9533((class_1927)this.explosion)) {
            class_2586 tileentity = blockstate.method_31709() ? this.world.method_8321(blockpos) : null;
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)tileentity);
            this.droppedItems.addAll(blockstate.method_26189(builder));
        }
        if (this.world instanceof class_3218) {
            for (class_3222 serverplayerentity : ((class_3218)this.world).method_18456()) {
                ((class_3218)this.world).method_14166(serverplayerentity, (class_2394)class_2398.field_11203, true, (double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), 2, 0.0, 0.0, 0.0, 0.0);
                ((class_3218)this.world).method_14166(serverplayerentity, (class_2394)class_2398.field_11251, true, (double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.world.method_8652(blockpos, class_2246.field_10124.method_9564(), 3);
        blockstate.method_26204().method_9586(this.world, blockpos, (class_1927)this.explosion);
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            CACHED_EXPLOSIONS.forEach(exploder -> exploder.onTick(world));
            CACHED_EXPLOSIONS.removeIf(exploder -> !exploder.iteration());
        });
    }
}

